; Written by: Fibergeek, http://www.codegurus.be/
; Date:       2004-10-07
; Subject:    Testing RIP relative addressing
;
; Updates:
;   2006-10-22
;     Added "public Main", this is needed from now on
;     Updated the command line you need to run
;     Turned "END Main" into a simple "END"
;
; Compile & Link: ml64 getrip.asm /link /subsystem:windows /defaultlib:kernel32.lib /defaultlib:user32.lib /entry:Main

extrn MessageBoxA: PROC
extrn ExitProcess: PROC

.data
testok    db 'RIP based addressing worked!', 0
testfail  db 'RIP based addressing didn''t work, failure at test '
testcode  db '0'
          db '!', 0
testtitle db 'RIP based addressing test by Fibergeek', 0

.code

public Main

Main:
  ; Put the value of the NOP opcode in R8B
  mov r8b, 90h

  ; Assume that the test failed
  lea rax, testfail

  ; Test 1
  ; NOTE: i'm hardcoding this instruction because ML64 is pretty dumb
  inc testcode
  DB 44h, 38h, 05h, 00h, 00h, 00h, 00h ; = cmp [rip], r8b = cmp [rip + 0], r8b
  nop
  jne done

  ; Test 2
  ; NOTE: i'm hardcoding this instruction because ML64 is pretty dumb
  inc testcode
  DB 48h, 8Dh, 1Dh, 00h, 00h, 00h, 00h ; = lea rbx, [rip] = lea rbx, [rip + 0]
  nop
  cmp [rbx], r8b
  jne done

  ; Test 3
  inc testcode
  call $ + 5
  nop
  pop rbx
  cmp [rbx], r8b
  jne done

  ; Test 4
  inc testcode
  call $ + 5
  pop rbx
  add rbx, 1 + 1 + 1 + 1 + 1 ; 1=POP, 1=REX, 1=ADD, 1=ModRM, 1=imm8
  nop
  cmp [rbx], r8b
  jne done

  ; All tests succeeded
  lea rax, testok

done:
  ; Display the result and exit the program returning the result of the MessageBox
  mov r9d, 0         ; R9D = UINT uType
  lea r8,  testtitle ; R8  = LPCTSTR lpCaption
  mov rdx, rax       ; RDX = LPCSTR lpText
  mov rcx, 0         ; RCX = HWND hWnd (0 = HWND_DESKTOP)
  call MessageBoxA
  mov ecx, eax       ; ECX = UINT uExitCode
  call ExitProcess

  ; Just in case :)
  ret
END
